Attribute VB_Name = "Module1"
Public Const AppName As String = "lmsoft"
Public Const Section As String = "Quick MCS"

Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

'Translate a hex number string to a dec number string
Public Function HexNumber(S As String, ByVal N As Long) As String
  Dim i As Long, V As Long
  Dim X As String
  HexNumber = ""
  V = 0
  For i = 1 To N
    V = V * 16
    X = Mid(S, i, 1)
    If X < "0" Then
      Exit Function
    ElseIf X <= "9" Then
      V = V + Asc(X) - Asc("0")
    ElseIf X < "A" Then
      Exit Function
    ElseIf X <= "F" Then
      V = V + Asc(X) - Asc("A") + 10
    ElseIf X < "a" Then
      Exit Function
    ElseIf X <= "f" Then
      V = V + Asc(X) - Asc("a") + 10
    Else
      Exit Function
    End If
  Next
  HexNumber = Format(V)
End Function

'translate a integer value to a hex string
Public Function HexString(ByVal Value As Long, ByVal Size As Integer)
  Dim N As Long
  HexString = ""
  Do While Size > 0
    N = Value And &HF&
    If N >= 10 Then
      HexString = Chr(Asc("A") + N - 10) & HexString
    Else
      HexString = Chr(Asc("0") + N) & HexString
    End If
    Value = Value \ 16
    Size = Size - 1
  Loop
End Function

Public Sub FilterNonNumber(KeyAscii As Integer)
  If KeyAscii < Asc("0") And KeyAscii <> 8 Or KeyAscii > Asc("9") Then KeyAscii = 0
End Sub

Public Function CommPort(Text As String) As Integer
  Dim S As String
  S = UCase(Trim(Text))
  If Left(S, 3) = "COM" Then S = Mid(S, 4)
  If IsNumeric(S) Then
    CommPort = S
  Else
    CommPort = 1
  End If
End Function

Public Function BaudRate(Text As String) As Long
  Dim S As String
  S = Trim(Text)
  If IsNumeric(S) Then
    BaudRate = S
  Else
    BaudRate = 9600
  End If
End Function

Private Function StrFindChars(ByVal Start As Long, ByVal Text As String, Chars As String) As Long
  Dim N As Long
  Dim S As String
  StrFindChars = 0
  Do While Start >= 1 And Start <= Len(Text)
    S = Mid(Text, Start, 1)
    N = InStr(Chars, S)
    If N > 0 Then
      StrFindChars = Start
      Exit Function
    End If
    Start = Start + 1
  Loop
End Function

Private Function StrSkipChars(ByVal Start As Long, Text As String, Chars As String) As Long
  Dim N As Long
  Dim S As String
  StrSkipChars = Start
  Do While Start >= 1 And Start <= Len(Text)
    S = Mid(Text, Start, 1)
    N = InStr(Chars, S)
    If N <= 0 Then
      StrSkipChars = Start
      Exit Function
    End If
    Start = Start + 1
  Loop
End Function

Public Function AddressList(Text As String, ByVal Hex As Boolean) As String
  Dim N1 As Long, N2 As Long
  Dim S1 As String, S2 As String
  AddressList = ""
  S1 = Trim(Text)
  N1 = 1
  Do While N1 <= Len(S1)
    N2 = StrFindChars(N1, S1, " ,;")
    If N2 <= 0 Then N2 = Len(S1) + 1
    S2 = ""
    If N2 > N1 Then S2 = Trim(Mid(S1, N1, N2 - N1))
    N1 = StrSkipChars(N2, S1, " ,;")
    If IsNumeric(S2) Then
      N2 = S2
      If N2 >= 0 And N2 < 256 Then
        If AddressList <> "" Then AddressList = AddressList & ","
        If Hex Then
          AddressList = AddressList & HexString(N2, 2)
        Else
          AddressList = AddressList & Format(N2)
        End If
      End If
    End If
  Loop
End Function

Public Function ConnectionType() As String
  ConnectionType = GetSetting(AppName, Section, "ConnectionType", "0")
End Function
